/*
-------------------------------------------------------------------------------
File:				vaids.h
Purpose:		COM Interfaces for Visual Studio Analyzer Eventing
System:			Visual Studio Analyzer Analysis.
Copyright:	(c) 1997, Microsoft Corporation
						All Rights Reserved
Tabs:				2,2
-------------------------------------------------------------------------------
*/

#ifndef msvsa_vaids_h
#define msvsa_vaids_h

// Events
#ifdef __midl
#define DECLARE_GUID MIDL_GUID
#define _MIDL_GUID(a,b,c,d,e,f,g,h,i,j,k) a ## - ## b ## - ## c ## - ## d ## e ## - ## f ## g ## h ## i ## j ## k
#define _MIDL_STRING(s) L ## # s
#define MIDL_STRING(s) _MIDL_STRING(s)
#define MIDL_GUID(name,a,b,c,d,e,f,g,h,i,j,k) const wchar_t name ## _STRING [] = MIDL_STRING(_MIDL_GUID(a,b,c,d,e,f,g,h,i,j,k)) 
#else
#define DECLARE_GUID NORMAL_GUID
#define MIDL_HEX(a) 0x ## a
#define MIDLHEX(a) MIDL_HEX(a)
#define NORMAL_GUID(name,a,b,c,d,e,f,g,h,i,j,k) DEFINE_GUID(name, MIDLHEX(a), MIDLHEX(b), MIDLHEX(c), MIDLHEX(d), MIDLHEX(e), MIDLHEX(f), MIDLHEX(g), MIDLHEX(h), MIDLHEX(i), MIDLHEX(j), MIDLHEX(k))
#endif

// {6c736d61-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_CALL, 
6c736d61, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d62-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_RETURN, 
6c736d62, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d63-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_COMPONENT_START, 
6c736d63, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d64-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_COMPONENT_STOP, 
6c736d64, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d65-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_CALL_DATA, 
6c736d65, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d66-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_ENTER, 
6c736d66, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d67-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_ENTER_DATA, 
6c736d67, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d68-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_LEAVE_NORMAL, 
6c736d68, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d69-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_LEAVE_EXCEPTION, 
6c736d69, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d6a-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_LEAVE_DATA, 
6c736d6a, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d6b-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_RETURN_DATA, 
6c736d6b, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d6c-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_RETURN_NORMAL, 
6c736d6c, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d6d-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_RETURN_EXCEPTION, 
6c736d6d, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d6e-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_QUERY_SEND, 
6c736d6e, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d6f-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_QUERY_ENTER, 
6c736d6f, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d70-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_QUERY_LEAVE, 
6c736d70, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d71-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_QUERY_RESULT, 
6c736d71, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d72-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_TRANSACTION_START, 
6c736d72, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d73-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_TRANSACTION_COMMIT, 
6c736d73, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d74-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_TRANSACTION_ROLLBACK, 
6c736d74, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d75-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_DEBUG_EVENTS_LOST, 
6c736d75, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// Event categories
// {6c736d81-BCBF-11D0-8A23-00AA00B58E10} [Parent = _ALL]
DECLARE_GUID(DEBUG_EVENT_CATEGORY_STARTSTOP, 
6c736d81, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d82-BCBF-11D0-8A23-00AA00B58E10} [Parent = _ALL]
DECLARE_GUID(DEBUG_EVENT_CATEGORY_CALLRETURN, 
6c736d82, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d83-BCBF-11D0-8A23-00AA00B58E10} [Parent = _ALL]
DECLARE_GUID(DEBUG_EVENT_CATEGORY_QUERYRESULT, 
6c736d83, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d84-BCBF-11D0-8A23-00AA00B58E10} [Parent = _ALL]
DECLARE_GUID(DEBUG_EVENT_CATEGORY_TRANSACTION, 
6c736d84, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d85-BCBF-11D0-8A23-00AA00B58E10} [Parent = GUID_NULL]
DECLARE_GUID(DEBUG_EVENT_CATEGORY_ALL, 
6c736d85, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d86-BCBF-11D0-8A23-00AA00B58E10}  [Parent = _ALL]
DECLARE_GUID(DEBUG_EVENT_CATEGORY_MEASURED_ALL, 
6c736d86, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);
// {6c736d87-BCBF-11D0-8A23-00AA00B58E10}  [Parent = _MEASURED_ALL]
DECLARE_GUID(DEBUG_EVENT_CATEGORY_PERFMON, 
6c736d87, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);

// The 'user' event source, which is autoregistered for all stock events
// {6c736d00-BCBF-11D0-8A23-00AA00B58E10}
DECLARE_GUID(DEBUG_EVENT_SOURCE_USER, 
6c736d00, bcbf, 11d0, 8a, 23, 00, aa, 00, b5, 8e, 10);

#ifndef __midl
DEFINE_GUID(CLSID_VSA_IEC, 
0x6c736dB1, 0xBD94, 0x11d0, 0x8a, 0x23, 0x00, 0xaa, 0x00, 0xb5, 0x8e, 0x10);
DEFINE_GUID(CLSID_VSA_IEC_AUTO, 
0x6c736dB3, 0xBD94, 0x11d0, 0x8a, 0x23, 0x00, 0xaa, 0x00, 0xb5, 0x8e, 0x10);
DEFINE_GUID(CLSID_VSA_ESI, 
0x6c736dB2, 0xBD94, 0x11d0, 0x8a, 0x23, 0x00, 0xaa, 0x00, 0xb5, 0x8e, 0x10);
DEFINE_GUID(CLSID_VSA_ESI_AUTO, 
0x6c736dB4, 0xBD94, 0x11d0, 0x8a, 0x23, 0x00, 0xaa, 0x00, 0xb5, 0x8e, 0x10);
#else
#define CLSID_VSA_IEC_S 6c736dB1-BD94-11D0-8A23-00AA00B58E10
#define CLSID_VSA_ESI_S 6c736dB2-BD94-11D0-8A23-00AA00B58E10
#define CLSID_VSA_IEC_AUTO_S 6c736dB3-BD94-11D0-8A23-00AA00B58E10
#define CLSID_VSA_ESI_AUTO_S 6c736dB4-BD94-11D0-8A23-00AA00B58E10
#endif

#endif
